<?php
/**
 * name             - Wireframe title
 * cat_name         - Comma separated list for multiple categories (cat display name)
 * custom_class     - Space separated list for multiple categories (cat ID)
 * dependency       - Array of dependencies
 * is_content_block - (optional) Best in a content block
 *
 * @version  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$wireframe_categories = UNCDWF_Dynamic::get_wireframe_categories();
$data                 = array();

// Wireframe properties

$data[ 'name' ]             = esc_html__( 'Grid Bento Creative', 'uncode-wireframes' );
$data[ 'cat_name' ]         = $wireframe_categories[ 'grids' ];
$data[ 'custom_class' ]     = 'grids';
$data[ 'image_path' ]       = UNCDWF_THUMBS_URL . 'grids/Grid-Bento-Creative.jpg';
$data[ 'dependency' ]       = array();
$data[ 'is_content_block' ] = false;

// Wireframe content

$data[ 'content' ]      = '
[vc_row unlock_row_content="yes" row_height_percent="0" override_padding="yes" h_padding="3" top_padding="5" bottom_padding="5" overlay_alpha="50" equal_height="justify" gutter_size="2" column_width_percent="100" shift_y="0" z_index="0" content_parallax="0" uncode_shortcode_id="469620" shape_dividers=""][vc_column column_width_percent="100" position_vertical="justify" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="0" width="1/4" uncode_shortcode_id="205134"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="816764"][vc_column_inner column_width_percent="100" gutter_size="3" override_padding="yes" column_padding="0" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="50" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="102308" back_color_type="uncode-palette"][vc_single_image media="'. uncode_wf_print_single_image( '80471' ) .'" media_width_percent="100" media_ratio="five-four" shape="img-round" radius="xl" uncode_shortcode_id="759211"][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="2" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="154347"][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="4" style="dark" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="50" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="3" mobile_width="3" width="1/3" uncode_shortcode_id="642061" back_color_type="uncode-palette"][vc_icon icon="fa fa-twitter-x" size="fa-2x" uncode_shortcode_id="371344" link="url:%23"][/vc_icon][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" style="dark" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="50" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="3" mobile_width="3" width="1/3" uncode_shortcode_id="844931" back_color_type="uncode-palette"][vc_icon icon="fa fa-social-facebook" size="fa-2x" uncode_shortcode_id="115237" link="url:%23"][/vc_icon][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" style="dark" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="50" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="3" mobile_width="3" width="1/3" uncode_shortcode_id="173473" back_color_type="uncode-palette"][vc_icon icon="fa fa-whatsapp1" size="fa-2x" uncode_shortcode_id="166342" link="url:%23"][/vc_icon][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="100" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="951120"][vc_column_inner column_width_percent="100" position_vertical="justify" gutter_size="4" style="dark" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" back_image="'. uncode_wf_print_single_image( '84889' ) .'" overlay_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="10" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="279703" back_color_type="uncode-palette" overlay_color_type="uncode-palette"][vc_custom_heading heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'fontsize-160000' ) .'" text_transform="uppercase" text_space="'. uncode_wf_print_font_space( 'fontspace-210350' ) .'" badge_style="yes" back_color="color-wayh" radius="lg" uncode_shortcode_id="100597" back_color_type="uncode-palette"]Tagline[/vc_custom_heading][vc_empty_space empty_h="5"][vc_empty_space empty_h="3"][vc_custom_heading heading_semantic="h3" text_size="'. uncode_wf_print_font_size( 'custom' ) .'" sub_lead="yes" sub_reduced="yes" uncode_shortcode_id="209126" subheading="35% increase in client satisfaction, a 50 rise in quarterly revenue." heading_custom_size="clamp(22px, 4vw, 28px)"]Medium length headline[/vc_custom_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_width_percent="100" position_vertical="justify" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="0" width="1/4" uncode_shortcode_id="213223"][vc_row_inner row_inner_height_percent="100" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="380340"][vc_column_inner column_width_percent="100" position_vertical="justify" gutter_size="4" style="dark" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" back_image="'. uncode_wf_print_single_image( '84889' ) .'" overlay_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="10" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="108401" back_color_type="uncode-palette" overlay_color_type="uncode-palette" mobile_height="50vh"][vc_custom_heading heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'fontsize-160000' ) .'" text_transform="uppercase" text_space="'. uncode_wf_print_font_space( 'fontspace-210350' ) .'" badge_style="yes" back_color="color-wayh" radius="lg" uncode_shortcode_id="497348" back_color_type="uncode-palette"]Tagline[/vc_custom_heading][vc_custom_heading heading_semantic="h3" text_size="'. uncode_wf_print_font_size( 'custom' ) .'" uncode_shortcode_id="296192" heading_custom_size="clamp(30px, 2vw, 45px)"]Medium length headline[/vc_custom_heading][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="202250"][vc_column_inner column_width_percent="100" position_vertical="justify" gutter_size="4" style="dark" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="50" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="130837" back_color_type="uncode-palette"][vc_pie value="92" arc_width="2" bar_color="" uncode_shortcode_id="604679" bar_color_type="uncode-solid" bar_color_solid="rgba(255,255,255,0.49)" units="%"][vc_custom_heading heading_semantic="h3" text_size="'. uncode_wf_print_font_size( 'custom' ) .'" sub_lead="yes" sub_reduced="yes" uncode_shortcode_id="227784" subheading="Successful completion of 20 high-impact projects within the fiscal year." heading_custom_size="clamp(22px, 4vw, 28px)"]Medium length headline[/vc_custom_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_width_percent="100" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="0" width="1/4" uncode_shortcode_id="206711"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="346679"][vc_column_inner column_width_percent="100" gutter_size="3" override_padding="yes" column_padding="0" style="dark" back_color="color-wayh" overlay_alpha="50" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="159255" back_color_type="uncode-palette"][vc_single_image media="'. uncode_wf_print_single_image( '80471' ) .'" media_width_percent="100" media_ratio="five-four" shape="img-round" radius="xl" uncode_shortcode_id="124736"][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="100" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="656961"][vc_column_inner column_width_percent="100" position_vertical="justify" gutter_size="3" style="dark" back_color="color-wayh" back_image="'. uncode_wf_print_single_image( '84889' ) .'" overlay_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="5" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="147082" back_color_type="uncode-palette" mobile_height="50vh" overlay_color_type="uncode-palette"][vc_custom_heading heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'fontsize-160000' ) .'" text_transform="uppercase" text_space="'. uncode_wf_print_font_space( 'fontspace-210350' ) .'" badge_style="yes" back_color="color-wayh" radius="lg" uncode_shortcode_id="816751" back_color_type="uncode-palette"]Tagline[/vc_custom_heading][vc_empty_space][vc_custom_heading heading_semantic="h3" text_size="'. uncode_wf_print_font_size( 'custom' ) .'" uncode_shortcode_id="109718" heading_custom_size="clamp(30px, 2vw, 45px)"]Medium length headline[/vc_custom_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_width_percent="100" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="0" width="1/4" uncode_shortcode_id="117143"][vc_row_inner row_inner_height_percent="100" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="651140"][vc_column_inner column_width_percent="100" position_vertical="justify" gutter_size="3" style="dark" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="50" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="102592" back_color_type="uncode-palette" el_class="overflow-hidden-uncell"][vc_custom_heading heading_semantic="h3" text_size="'. uncode_wf_print_font_size( 'custom' ) .'" uncode_shortcode_id="152667" heading_custom_size="clamp(22px, 4vw, 28px)"]Long headline to turn your visitors into users[/vc_custom_heading][vc_custom_heading heading_semantic="div" text_size="'. uncode_wf_print_font_size( 'custom' ) .'" inline_media="'. uncode_wf_print_single_image( 'yes' ) .'" medias="'. uncode_wf_print_multiple_images( array( 80471 ) ) .'" media_ratio="one-one" media_height="100" media_space="gutter" shape="img-circle" css_alt_animation="marquee" marquee_clone_alt="yes" marquee_speed_alt="-2" uncode_shortcode_id="475501" heading_custom_size="clamp(80px,10vw,120px)"][<a href="#">uncode_inline_image</a>][<a href="#">uncode_inline_image</a>][<a href="#">uncode_inline_image</a>][<a href="#">uncode_inline_image</a>][/vc_custom_heading][vc_button size="link" btn_link_size="h4" btn_link_underline="btn-underline-out" custom_typo="yes"  font_weight="600" uncode_shortcode_id="162499"]Click the button[/vc_button][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="137438"][vc_column_inner column_width_percent="100" gutter_size="3" override_padding="yes" column_padding="0" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="50" radius="xl" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="458496" back_color_type="uncode-palette"][vc_single_image media="'. uncode_wf_print_single_image( '80471' ) .'" media_width_percent="100" media_ratio="five-four" shape="img-round" radius="xl" uncode_shortcode_id="323302"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
';

// Check if this wireframe is for a content block
if ( $data[ 'is_content_block' ] && ! $is_content_block ) {
	$data[ 'custom_class' ] .= ' for-content-blocks';
}

// Check if this wireframe requires a plugin
foreach ( $data[ 'dependency' ]  as $dependency ) {
	if ( ! UNCDWF_Dynamic::has_dependency( $dependency ) ) {
		$data[ 'custom_class' ] .= ' has-dependency needs-' . $dependency;
	}
}

vc_add_default_templates( $data );
