<?php

die( 'filter_examples.php contains examples only' );

/*********
 * dwls_alter_results example
 *
 * We have a Custom Post Type called "liveblog" for our coverage of Apple keynotes.
 * Flag those search results with [LiveBlog] so people know those are LiveBlog posts and not actual articles.
 *
 * @param array                           $wpQueryResults Array of WP_Post objects
 * @param                                 $deprecated
 * @param DavesWordPressLiveSearchResults $davesWordPressLiveSearchResults
 *
 * @return mixed
 */
function add_liveblog_flag( $wpQueryResults, $deprecated, $davesWordPressLiveSearchResults ) {

	// Loop through all the search results
	foreach ( $wpQueryResults as $result ) {
		if ( $result->post_type === 'liveblog' ) {
			$result->post_title = '[LiveBlog] ' . $result->post_title;
		}
	}

	return $wpQueryResults;

}

add_filter( 'dwls_alter_results', 'add_liveblog_flag', 10, 3 );

/**
 * dwls_attachment_thumbnail example.
 *
 * Who's the leader of the blog that's made for you and me? That's right, we're going to make
 * every post's thumbnail a picture of Mickey Mouse (or we would if I had an image of Mickey to
 * link to -- just using a fake image for now, so you'll get broken images)
 *
 * @param string $thumbnail URL
 *
 * @return string URL
 */
function every_thumbnail_mickey( $thumbnail ) {
	return 'http://example.com/mickeymouse.jpg';
}

add_filter( 'dwls_attachment_thumbnail', 'every_thumbnail_mickey' );

/**
 * dwls_post_title example.
 *
 * I CAN'T HEAR YOU! Format all post titles in the Live Search results using uppercase letters.
 *
 * @param string $title
 *
 * @return string modified title
 */
function all_titles_uppercase( $title ) {
	return strtoupper( $title );
}

add_filter( 'dwls_post_title', 'all_titles_uppercase' );

/**
 * dwls_the_excerpt example.
 *
 * By default, WordPress generates an excerpt of about 55 words. But that's too long for our fast-paced, online digital
 * world! I people can't get the idea of what a post is about in 10 characters, then I don't care if they read it or
 * not. Display a 10 character summary in the search results.
 *
 * @param string $excerpt Generated by WordPress
 *
 * @return string modified excerpt
 */
function really_short_excerpt( $excerpt ) {
	return substr( $excerpt, 0, 10 );
}

add_filter( 'dwls_the_excerpt', 'really_short_excerpt' );

/**
 * dwls_post_date example.
 *
 * Buzz Aldrin didn't really blog from the moon. But what if he did? Of course, he's not too happy to be reminded that
 * trip was so long ago. Let's add 20 years to the date of every post.
 *
 * @param int $post_date
 *
 * @return int
 */
function over_the_moon( $post_date ) {
	$date = DateTime::createFromFormat( 'U', $post_date );
	$date->modify( '+20 years' );

	return $date->format( 'U' );
}

add_filter( 'dwls_post_date', 'over_the_moon' );

/**
 * dwls_author_name example.
 *
 * Our bloggers don't want their names to appear in the Live Search results (they're very shy). Display the name
 * "Kilroy" in place of the authors' names.
 *
 * @param string $author
 *
 * @return string always "Kilroy"
 */
function kilroy_was_here( $author ) {
	return 'Kilroy';
}

add_filter( 'dwls_author_name', 'kilroy_was_here' );

/**
 * dwls_alter_result_template example.
 *
 * The default markup used by Dave's WordPress Live Search is ok, but I'd really prefer if it looked a little cooler.
 * Maybe I have a different template I want to use, with pictures of kittens between every search result.
 * Yeah, let's use that.
 *
 * @param string $template
 *
 * @return string modifed template or a completely new one
 */
function my_custom_results_template( $template ) {

	/**
	 * The original template file is in 'js/dwls-results.tpl' and is coded to work with the Underscore.js library.
	 * Feel free to copy it and customize the markup to your heart's content.
	 * @see http://underscorejs.org/#template
	 */
	return file_get_contents( 'path/to/my_alternate_template_file.tpl' );

}

add_filter( 'dwls_alter_result_template', 'my_custom_results_template' );

/**
 * dwls_post_custom example.
 *
 * Let's say the template from my 'dwls_alter_result_template' example above includes a field for the weather. This
 * filter lets me populate a custom variable with the weather at the time the post was written (I don't really have
 * a function to do this, but let's pretend). That way, I can show it in the template with
 * <%= searchResult.weather %></p>
 *
 * @param WP_Post $post
 *
 * @return WP_Post
 */
function my_dwls_template_variables( $post ) {

	$post->weather = get_the_weather_for_date( $post->post_date );

	return $post;

}

add_filter( 'dwls_post_custom', 'my_dwls_template_variables' );

/**
 * dwls_query_fields example.
 *
 * In order to keep memory usage low and speed up the Live Search overall, Dave's WordPress Live Search only retrieves
 * a limited number of database fields for each post: 'ID', 'post_author', 'post_content', 'post_excerpt', 'post_date',
 * and 'post_title'. This filter lets you add additional wp_posts fields to the results, which you can then use in
 * custom templates.
 *
 * @param array $fields
 *
 * @return array
 */
function i_want_more_fields( array $fields ) {

	$fields[] = 'post_type';

	return $fields;

}

add_filter( 'dwls_query_fields', 'i_want_more_fields' );